/*:
 * @target MZ
 * @plugindesc PKD_Spine2DPlayer 用 追加パッチ：最後のアニメ状態をできるだけ保持する
 * @author HS
 * @help
 * 使い方:
 *   PKD_Spine2DPlayer.js と HS_PKDSpine_Fix_SaveCancel.js の「下」に入れてください。
 *
 * やっていること:
 *   1) stopAnimation / _onEnd が lastAnimationState を null にしないように上書き
 *   2) makeSavedata() で lastAnimationState が空なら、現在の再生中アニメから補完
 */

(() => {
  if (!window.PKD_Sprite_SpineAnimation) return;
  const proto = PKD_Sprite_SpineAnimation.prototype;

  // 1) stopAnimation で lastAnimationState を消さないようにする
  if (proto.stopAnimation) {
    const _stopAnimation = proto.stopAnimation;
    proto.stopAnimation = function(mixDuration = 0, trackIndex = 0) {
      const prev = Array.isArray(this.lastAnimationState)
        ? this.lastAnimationState.slice()
        : null;
      const r = _stopAnimation.call(this, mixDuration, trackIndex);
      try {
        if (!this.lastAnimationState && prev && prev[0]) {
          this.lastAnimationState = prev;
        }
      } catch (e) { console.warn(e); }
      return r;
    };
  }

  // 2) アニメ終了時（_onEnd）でも lastAnimationState を残す
  if (proto._onEnd) {
    const _onEnd = proto._onEnd;
    proto._onEnd = function(entry) {
      const prev = Array.isArray(this.lastAnimationState)
        ? this.lastAnimationState.slice()
        : null;
      const r = _onEnd.call(this, entry);
      try {
        if (!this.lastAnimationState && prev && prev[0]) {
          this.lastAnimationState = prev;
        }
      } catch (e) { console.warn(e); }
      return r;
    };
  }

  // 3) セーブ時（makeSavedata）に lastAnimationState が空なら現在のアニメから補完
  if (proto.makeSavedata) {
    const _makeSavedata = proto.makeSavedata;
    proto.makeSavedata = function() {
      const saveObject = _makeSavedata.call(this);
      try {
        const hasAnim =
          saveObject &&
          Array.isArray(saveObject.lastAnimationState) &&
          saveObject.lastAnimationState[0];

        if (!hasAnim && typeof this.getAnimationState === "function") {
          const st = this.getAnimationState();
          if (st && st.tracks && st.tracks.length > 0) {
            const entry = st.tracks[0];
            if (entry && entry.animation && entry.animation.name) {
              const name = entry.animation.name;
              const loop = !!entry.loop;
              const mix  = entry.mixDuration || 0;
              const idx  = (typeof entry.trackIndex === "number") ? entry.trackIndex : 0;
              const arr  = [name, loop, mix, idx];
              saveObject.lastAnimationState = arr;
              this.lastAnimationState = arr.slice();
            }
          }
        }
      } catch (e) { console.warn(e); }
      return saveObject;
    };
  }
})();
